package com.wissamfawaz;

import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        String code;
        Scanner scan = new Scanner(System.in);
        int areaInfo;
        char city;
        int valid = 0, banned = 0;

        System.out.println("Enter a product code (XXX to quit): ");
        code = scan.nextLine();

        while (!code.equalsIgnoreCase("XXX")) {
            try {
                code = code.trim().toUpperCase();
                    
                if (code.length() != 5) {
                    throw new StringIndexOutOfBoundsException();
                }

                city = code.charAt(4);
                areaInfo = Integer.parseInt(code.substring(0, 4));

                if (areaInfo >= 2000 && city == 'B') {
                    banned++;
                }

                valid++;
            } catch (NumberFormatException e) {
                System.out.println("Area info must be numeric.");
            } catch (StringIndexOutOfBoundsException e) {
                System.out.println("Code should have 4 digits followed by a character");
            }

            System.out.println("Enter a product code (XXX to quit): ");
            code = scan.nextLine();
        }

        System.out.println("# valid codes: " + valid);
        System.out.println("# banned codes: " + banned);
        scan.close();

    }

}
